package ch.frankel.blog.lombok.handler;

import lombok.javac.JavacNode;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class ClassTypeParamMapper implements Mapper<Class<?>, Symbol> {

    /** Node. */
    private final JavacNode node;

    /**
     * Constructor.
     * 
     * @param node
     *            Node
     */
    public ClassTypeParamMapper(JavacNode node) {

        this.node = node;
    }

    /**
     * @see ch.frankel.blog.lombok.handler.Mapper#get(java.lang.Object)
     */
    public Symbol get(Class<?> clazz) {

        Name name = node.toName(clazz.getName());

        return node.getSymbolTable().classes.get(name);
    }
}
